
-- Rain parameters
kPPS = 15;               -- Number of particles generated per second
kGravity =400 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("heart");
  SetBlendMode(kBlendNormal);
  SetNumParticles(1);
end

floor = math.floor
delayBeforeStart=800;
ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(delayBeforeStart+100);
TestDone = NewTimeout(2000+delayBeforeStart);
StartTime = NewTimeout(delayBeforeStart);

function Update(ms)

  if (not StartTime(ms)) then
   return;
  end
  
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-5, -5), Vec3(5, 4) );
   InitVelocity( "vRange", Vec3(-.1,.2), Vec3(.1,.2) );
   InitScale( "fRange", 0.2, 1);
   InitAge("iRange", 0, 1);
   CreateParticles(newParticles);
  end

Gravity(-.25* kGravity);

   Do("move");
   DoAge("iAge");
DoColor("cFade",
      --Color(1, 1, 1, 5), 200,
      --Color(1, 1, 1, 5), 200,
      Color(125, 125, 125, 5));
   DoScale("fScale",
      .2, 1000,
      1, 200);
   Do("expire", 1000)

--DoUp( "vRotate", , );


end

